function OpenTrack()

global Tracks;
global Prefs;

if exist(Prefs.DefaultPath, 'dir') 
    cd(Prefs.DefaultPath);
end

[FileName, PathName] = uigetfile('*.mat', 'Open Track File');

if FileName
	% Get tracks
    load([PathName,FileName]);
    Prefs.NewTracksFile = 1;
	
    
    NumMovies = 1;
    % Get movie(s) from which tracks were derived for display
    Message = 'Select Movie for Display with Tracks';
    if NumMovies == 2
        Message = 'Select First Movie for Display with Tracks';
    end
    
        save defaultname FileName PathName;   


    cd(PathName);
    
    x= load('extension.mat');

    
    if strcmp(FileName(size(FileName,2)-4) , 'a')
        
     FileName = char(strcat(FileName(1: size(FileName,2)-5), x.ext));

     
    else
     
     FileName = char(strcat(FileName(1: size(FileName,2)-4), x.ext));   
   
        
    end 
    
    
    cd(PathName);
    
    
    if FileName == 0
        errordlg('No movie was selected for display');
        return;
    end
    Prefs.MovieName = [PathName, FileName];

    Object1 = VideoReader(Prefs.MovieName(1,:));
    nFrames = Object1.NumberOfFrames;
    Prefs.FirstMovieLen =  nFrames;  
    MovieLen = Prefs.FirstMovieLen;
    
    if NumMovies == 2
        [FileName, PathName] = uigetfile('*.avi', 'Select Second Movie for Display with Tracks');
        if FileName == 0
            errordlg('No movie was selected for display');
            return;
        end
        Prefs.MovieName(2,:) = [PathName, FileName];
        FileInfo = aviinfo(Prefs.MovieName(2,:));
        
        Object2 = VideoReader(Prefs.MovieName(2,:));
        nFrames2 = Object2.NumberOfFrames;
        FileInfo.NumFrames =  nFrames2; 
        
        MovieLen = MovieLen + FileInfo.NumFrames;
    end

	% Display number of frames in movie(s)
    H = findobj('tag', 'FRAMETOTAL');
    set(H, 'String', ['of    ', num2str(MovieLen)]);
    
    % Set track selector slider to 1
    NumTracks = length(Tracks);
    H = findobj('tag', 'SLIDER');
	set(H, 'enable', 'on', ...
        'Value', 1, ...
        'SliderStep', [1,10]/NumTracks, ...
        'Max', NumTracks, ...
        'Min', 1);
    SelectTrack;  
    
    
	% Enable track analysis and playback
    H = findobj('tag', 'ANALYZE');
	set(H, 'enable', 'on');
    H = findobj('tag', 'BATCH');
	set(H, 'enable', 'on');
    
    H = findobj('tag', 'SAVE');
    set(H, 'enable', 'on');
 
    H = findobj('tag', 'SINGLE_SPEED_HIST');
    set(H, 'enable', 'on');
    H = findobj('tag', 'SINGLE_ID_PARAL');
    set(H, 'enable', 'on');

    H = findobj('tag', 'RW');
	set(H, 'enable', 'on');
	H = findobj('tag', 'BACK');
	set(H, 'enable', 'on');
	H = findobj('tag', 'PLAY');
	set(H, 'enable', 'on');
	H = findobj('tag', 'FF');
	set(H, 'enable', 'on');
	H = findobj('tag', 'BEGIN');
	set(H, 'enable', 'on');
	H = findobj('tag', 'END');
	set(H, 'enable', 'on');
    
  	H = findobj('tag', 'DELETE');
	set(H, 'enable', 'on');
end
